----------------
title : C 언어 레퍼런스 - setvbuf 함수
cat_title :  setvbuf
publish_date : 2010-02-18
ref_title : setvbuf
path : /C Reference/stdio.h
--------------



```warning
아직 C 언어와 친숙하지 않다면, [씹어먹는 C 언어 강좌](http://itguru.tistory.com/notice/15)를 보는 것이 어떻까요?

```

#@ setvbuf

```cpp
#include <stdio.h> // C++ 에서는 <cstdio>

int setvbuf ( FILE * stream, char * buffer, int mode, size_t size );

```

스트림 버퍼링 방식을 변경한다.

버퍼를 특정한 스트림의 입출력 연산에 사용될 수 있도록 변경한다. 이 함수는 버퍼링 방식과 버퍼의 크기를 설정할 수 있게 지원한다.

버퍼의 크기는 세번째 인자에 바이트 수로 전달된다.

만일 버퍼를 설정하지 않는다면 (즉, 두 번째 인자가 `NULL` 이라면), 시스템은 동적으로, 함수에 의해 요청된 크기 만큼 메모리를 할당하게 되며 이를 스트림의 버퍼로 사용하게 된다.

`mode` 인자는 이 버퍼를 fully buffered, line buffered, 아니면 unbuffered 로 할 지 결정한다.

**fully buffered** 스트림의 경우 읽기 작업은 스트림에 대응되는 장비에 바로 쓰여지지 않는다. 그 대신에 쓰여질 데이터는 버퍼에 잠시 저장되었다가 버퍼에 일정한 블록 이상 쌓이게 되면 그제서야 장비에 쓰여지게 된다.

물론, 한 블록이 다 채워지지 않았는데도 불구하고 스트림을 강제로 비움으로써 (flush) 장비에 쓸 수 있는데 이는 [fflush](http://itguru.tistory.com/57)함수를 호출하거나 [fclose](http://itguru.tistory.com/54)함수를 호출해 파일을 닫으면 된다. 참고적으로 모든 버퍼는 프로그램이 종료시 자동적으로 비워지게 된다.

**line buffered** 스트림의 경우 버퍼에 개행 문자가 입력될 때 마다 장비에 쓰여지게 된다.

**unbuffered** 스트림의 경우 데이터는 버퍼와 같은 중간 경유지를 거치지 않고 직접적으로 쓰여지게 된다. 즉, 쓰기 작업을 할 때 바로바로 쓰이게 된다.

모든 열려진 파일들은 기본적으로 할당된 버퍼를 가지고 있다. 이 함수는 그렇게 할당된 버퍼의 크기를 재조정 하거나, 사용자가 특별히 할당한 버퍼로 버퍼를 바꾸거나, 파일의 버퍼링 방식을 변경할 수 있게 해준다. 표준 출력(stdout) 이나 표준 오류(stderr) 같은 시스템 표준 스트림은 리다이렉트(redirect) 되지 않는 한 기본적으로 unbuffered 로 설정되어 있다.



###  인자

`stream`

작업을 수행할 열린 스트림의 `FILE` 객체를 가리키는 포인터.

`buffer`

유저가 할당한 버퍼로 최소한 1 바이트의 크기는 되야 한다.
만일 `NULL` 로 설정하면 함수는 자동으로 지정한 크기의 버퍼를 할당하게 된다

`mode`

파일 버퍼링의 형식을 지정한다.

* `_IOFBF` 완전한 버퍼링(Full Buffering): 앞에서 설명한 fully buffered 스트림을 일컫는다.
* `_IOLBF` 행 버퍼링(Line Buffering): 출력시, 버퍼가 채워지거나 스트림에 개행 문자가 입력되었다면 데이터가 버퍼에서 출력된다. 입력 시에는 버퍼가 개행 문자를 만날 때 까지 버퍼를 채우게 된다.
* `_IONBF` 버퍼링 사용 안함(No Buffering): 버퍼를 사용하지 않는다. 각각의 입출력 작업은 버퍼를 지나지 않고 요청 즉시 진행되며 이 겨우 `buffer` 인자와 `size` 인자는 모두 무시된다.

`size`

지정할 버퍼의 크기로 단위는 바이트 이다. 이 때, 버퍼로 지정한 배열의 크기 보다 반드시 작거나 같아야 한다.

만일 이 인자가 `NULL` 이라면 컴퓨터가 스스로 버퍼가 취할 수 있는 최소의 크기를 결정하게 된다.



###  리턴값

만일 버퍼가 성공적으로 지정 되었다면 0 이 리턴된다.

그렇지 않을 경우 0 이 아닌 값이 리턴되는데 보통 적당하지 않은 `size` 값을 인자로 넘겼거나, `size` 에 `NULL` 을 넘겼지만 컴퓨터가 메모리를 할당하는 과정 중 오류가 발생하는 경우이다.



###  실행 예제


```cpp-formatted
/*

파일을 _IOFBF 형식으로 열며, 버퍼는 크기가 1024 바이트로 컴퓨터가 자동으로
할당하게 한다. 이 예제는
http://www.cplusplus.com/reference/clibrary/cstdio/setvbuf/ 에서 가져왔습니다.

 */
#include <stdio.h>
int main() {
  FILE *pFile;
  pFile = fopen("myfile.txt", "w");
  setvbuf(pFile, NULL, _IOFBF, 1024);

  /* 여러 파일 입출력 작업들 */

  fclose(pFile);

  return 0;
}
```


스트림 버퍼 형식이 `_IOFBF,` 즉 fully buffered 스트림이기 때문에 버퍼가 다 차지 않는 이상 쓰기 작업을 하지 않게 된다. 즉, 버퍼에 1024 바이트 이상 쓰이지 않는 이상 `myfile.txt` 에 쓰이지 않는다.



###  참고 자료

*  [setbuf](http://itguru.tistory.com/61)  :  스트림 버퍼를 설정한다.
*  [fopen](http://itguru.tistory.com/58)   :  파일을 연다.
*  [fflush](http://itguru.tistory.com/57)   :  스트림을 비운다.